package com.pay.demo.controller;


import com.pay.demo.util.HttpUtils;
import com.pay.demo.util.Md5Utils;
import com.pay.demo.vo.CallbackParam;
import com.pay.demo.vo.Order;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;

/**
 * 订单
 * 
 */
@Controller()
@RequestMapping("/order")
public class OrderController
{
    private String prefix = "order";

    // 商户号
    private String merchno = "merchno";
    // 商户秘钥
    private String secretKey = "secretKey";

    /**
     * 构建下单请求参数
     * @param order
     * @return
     */
	@RequestMapping("/buildOrderInfo")
    @ResponseBody
    public Object buildOrderInfo(Order order)
    {
        ///////////////////////////////
        // 省略 验参 步骤
        ///////////////////////////////

        TreeMap<String, Object> params = new TreeMap<>();
        params.put("merchno", merchno);
        params.put("orderId", order.getOrderId());
        params.put("payType", order.getPayType());
        params.put("amount", order.getAmount().setScale(2).toString());
        params.put("asyncUrl", order.getAsyncUrl());
        params.put("syncUrl", order.getSyncUrl());
        params.put("requestTime",  new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        params.put("attach", order.getAttach());

        params.put("requestCurrency",order.getRequestCurrency());// 请求货币
        params.put("apiVersion",order.getApiVersion());// api版本号

        String toSignStr = HttpUtils.buildParamString(params);
        toSignStr += "&secretKey=" + secretKey;

        String sign = Md5Utils.hash(toSignStr).toLowerCase();

        params.put("sign", sign);

        return params;
    }

    /**
     * 异步回调通知接口
     * @param callbackParam
     * @return
     */
    @RequestMapping("/asyncCallback")
    @ResponseBody
    public Object asyncCallback(CallbackParam callbackParam) {
        ///////////////////////////////
        // 省略 验参 步骤
        ///////////////////////////////

        TreeMap<String, Object> params = new TreeMap();
        params.put("merchno", callbackParam.getMerchno());
        params.put("orderId", callbackParam.getOrderId());
        params.put("amount", callbackParam.getAmount());
        params.put("payType", callbackParam.getPayType());
        params.put("attach", callbackParam.getAttach());
        params.put("status", callbackParam.getStatus());

        params.put("requestCurrency", callbackParam.getRequestCurrency());
        params.put("apiVersion", callbackParam.getApiVersion());

        String paramStr = HttpUtils.buildParamString(params);
        String toSignStr = paramStr + "&secretKey=" + secretKey;

        String calcSign = Md5Utils.hash(toSignStr).toLowerCase();

        boolean isValidate = calcSign.equals(callbackParam.getSign());

        if (isValidate) {
            ///////////////////////////////
            // 省略 确认订单，并入账 步骤
            ///////////////////////////////
        }

        System.out.println(HttpUtils.buildParamString(params) + ":::::::::::::" + isValidate) ;

        return isValidate ? "success" : "fail";
    }


}
